#locate OpenCL library

if (OPENCL_LIBRARY AND OPENCL_INCLUDE_DIR)
	set (OPENCL_FOUND TRUE)
else (OPENCL_LIBRARY AND OPENCL_INCLUDE_DIR)
	set (OPENCL_HINT_PATHS /usr /usr/local $ENV{AMDAPPSDKROOT} $ENV{CUDA_PATH} $ENV{INTELOCLSDKROOT})
	foreach (OPENCL_HINT_PATH ${OPENCL_HINT_PATHS})
		find_path (OPENCL_INCLUDE_DIR CL/cl.h HINTS ${OPENCL_HINT_PATH}/include)
		if (CMAKE_SIZEOF_VOID_P EQUAL 8)
			find_library (OPENCL_LIBRARY NAMES OpenCL libOpenCL HINTS ${OPENCL_HINT_PATH}/lib/x86_64 ${OPENCL_HINT_PATH}/lib/x64 ${OPENCL_HINT_PATH}/lib64 ${OPENCL_HINT_PATH}/lib)
		else (CMAKE_SIZEOF_VOID_P EQUAL 8)
			find_library (OPENCL_LIBRARY NAMES OpenCL libOpenCL HINTS ${OPENCL_HINT_PATH}/lib/x86 ${OPENCL_HINT_PATH}/lib)
		endif (CMAKE_SIZEOF_VOID_P EQUAL 8)
	
		if (OPENCL_LIBRARY AND OPENCL_INCLUDE_DIR)
			set (OPENCL_FOUND TRUE)
			message (STATUS "Found OpenCL library: ${OPENCL_LIBRARY}")
			message ("Found OpenCL library at ${OPENCL_HINT_PATH}.")
			break (OPENCL_HINT_PATH)
		endif (OPENCL_LIBRARY AND OPENCL_INCLUDE_DIR)
	endforeach (OPENCL_HINT_PATH)

	if (NOT (OPENCL_LIBRARY AND OPENCL_INCLUDE_DIR))
		set (OPENCL_FOUND FALSE)
		message (SEND_ERROR "Could NOT find OpenCL")
		message ("Couldn't find an OpenCL SDK automatically.")
		message ("Please specify it manually, with options -DOPENCL_LIBRARY and -DOPENCL_INCLUDE_DIR.")
	endif (NOT (OPENCL_LIBRARY AND OPENCL_INCLUDE_DIR))
endif (OPENCL_LIBRARY AND OPENCL_INCLUDE_DIR)
